package eu.europa.ec.taxud.cesop.validation;

/**
 * Data class with CESOP validation settings like limits and thresholds.
 * These settings affect whether some validation errors are fired or not.
 */
public class ValidationSettings {
    private final int businessMinPeriod;
    private final long maxSize;
    private final int maxErrors;

    /**
     * Create default validation settings.
     *
     * @return the validation settings
     */
    public static ValidationSettings createDefault() {
        final long maxFileSize = 1000000000L; // better be the same as the real ${psp.xsd.max.size} value
        final int minBusinessPeriod = 20211; // static for now, but can be something like Q1 of the last year
        final int maxErrors = 5000;
        return new ValidationSettings(minBusinessPeriod, maxFileSize, maxErrors);
    }

    /**
     * Instantiates a new Validation settings.
     *
     * @param businessMinPeriod the business min period
     * @param maxSize           the max size
     * @param maxErrors         the max errors
     */
    public ValidationSettings(Integer businessMinPeriod, long maxSize, Integer maxErrors) {
        this.businessMinPeriod = businessMinPeriod;
        this.maxSize = maxSize;
        this.maxErrors = maxErrors;
    }

    /**
     * Gets business min period.
     *
     * @return the business min period
     */
    public Integer getBusinessMinPeriod() {
        return businessMinPeriod;
    }

    /**
     * Gets max size.
     *
     * @return the max size
     */
    public long getMaxSize() {
        return maxSize;
    }

    /**
     * Gets max errors.
     *
     * @return the max errors
     */
    public int getMaxErrors() {
        return maxErrors;
    }
}
